<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cliente extends Model 
{

    protected $table = 'clientes';
    public $timestamps = true;
    protected $fillable = array('nombres', 'apellidos', 'email', 'celular', 'telefono', 'fecha_nacimiento', 'id_pais');

    public function pais_titular()
    {
        return $this->belongsTo('App\Models\Pais', 'id_pais');
    }

    public function pais_conyuge()
    {
        return $this->belongsTo('App\Models\Pais', 'pais_id_conyuge');
    }

    public function hijos()
    {
        return $this->hasMany('Hijo', 'id_cliente');
    }

    public function factfinds()
    {
        return $this->hasMany('App\Models\Factfind', 'id_cliente');
    }

}